@extends('layout.app')
@section('content')

    <div class="card">
        <div class="card-body">

            <form action="{{ route('sub-reseller-commission', $pop->id) }}" method="post" id="search">
                @csrf
                @method('post')
                <div class="row">
                    <div class="col-md-4">
                        <div class="form-group">
                            <div class="input-group date" id="searchFrom" data-target-input="nearest">
                                <input value="{{ $start->format('m/d/y') }}" type="text" name="from_date"
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchFrom" autocomplete="off">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group">
                            <div class="input-group date" id="searchTo" data-target-input="nearest">
                                <input value="{{ $end->format('m/d/y') }}" type="text" name="to_date"
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchTo" autocomplete="off">
                            </div>
                        </div>
                    </div>
                    <div class="col-md-4">
                        <div class="form-group float-right">
                            <button @click="search" class="btn btn-primary" type="submit" id="searchBtn"><i
                                    class="fa fa-search"></i> Search</button>
                        </div>
                    </div>
                </div>

                <div id="result">
                    {{-- list will show in this box --}}
                </div>
            </form>
            <div class="table-responsive">
                <table class="table" style="width:100%">
                    <thead style="width:100%">
                        <tr>
                            <th class="bg-dark">Date</th>
                            <th class="bg-dark">Particulars</th>
                            <th class="bg-dark">Commission</th>
                            <th class="bg-dark">Paid Commission</th>
                            <th class="bg-dark">Balance</th>
                            <th class="bg-dark">Remarks/Narration</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td></td>
                            <td></td>
                            <td class="bg-light"></td>
                            <td class="">Opening Balance:</td>
                            <td class="bg-light">{{ $opening_balance }}</td>
                            <td class=""></td>
                        </tr>
                        {{-- @dd($accounts) --}}
                        @foreach ($accounts as $account)
                            <tr>
                                <td>{{ $account->created_at }}</td>
                                <td>{{ $account->actions }}</td>
                                <td class="bg-light">{{ $account->received_amount }}</td>
                                <td class="">{{ $account->paid_amount }}</td>
                                <td class="bg-light">{{ $account->cur_balance }}</td>
                                <td class="">{{ $account->comments }}</td>
                            </tr>
                        @endforeach
                        <tr>
                            <td class="bg-secondary text-right" colspan="2" class="text-right">Total:</td>
                            <td class="bg-secondary" class="bg-light">{{ $accounts->sum('received_amount') }}</td>
                            <td class="bg-secondary">{{ $accounts->sum('paid_amount') }}</td>
                            <td class="bg-secondary">
                                {{ $accounts->sum('received_amount') + $opening_balance - $accounts->sum('paid_amount') }}
                            </td>
                            <td class="bg-secondary"></td>
                        </tr>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

@endsection
