<?php

namespace App\Console\Commands;

use App\Jobs\UniqueSlugInsertJob;
use App\Models\Client;
use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;

class UniqueSlugInsert extends Command
{
    protected $signature = 'unique:slug';

    protected $description = 'Client Unique slug insert';

    public function __construct()
    {
        parent::__construct();
    }

    public function handle()
    {
        // Log::info("log -unique:slug");

        $this->info("start to Client Unique slug insert \n");

        Client::select('id', 'userid')
            ->chunk(100, function ($clients) {
                UniqueSlugInsertJob::dispatch($clients);
            });

        $this->info("End to Client Unique slug insert \n");
    }
}
