@extends('layout.app')


@push('styles')
    <link rel="stylesheet" type="text/css" href="{{ asset('taginput/bootstrap-tagsinput.css') }}" crossorigin="anonymous"
        referrerpolicy="no-referrer">
    <style type="text/css">
        .bootstrap-tagsinput {
            width: 100%;
        }

        .label-info {
            background-color: rgb(36, 219, 204);
        }

        .label {
            /* display: inline-block; */
            padding: .25em .4em;
            font-size: 75%;
            font-weight: 700;
            line-height: 1;
            text-align: center;
            white-space: nowrap;
            vertical-align: baseline;
            border-radius: .25rem;
            transition: color .15s ease-in-out, background-color .15s ease-in-out,
                border-color .15s ease-in-out, box-shadow .15s ease-in-out;
        }
    </style>
@endpush

@section('content')

    <form action="{{ route('clients.update', $r->client_id ?? $r->id) }}" method="POST" class="form"
        enctype="multipart/form-data">
        @method('PUT')
        @csrf

        <div class="card">
            <div class="card-body">
                @if (checkSettings('profilePicture') == 'enable')
                    @if ($r->pop->bill_generate == 'yes' || checkSettings('file_up_for_own_other') == 'enable')
                        <div class="row" id="file_info">
                            <div class="form-group col-sm-2">
                                <div class="text-center mb-1 image-info"></div>
                                @if (checkSettings('store_image_to_s3') == 'enable')
                                    @php
                                        $s3Url = Storage::disk('s3')->url(
                                            'customer_profile_picture/' . $r->clientsinfo->customer_profile_picture,
                                        );
                                    @endphp

                                    <img width="auto" height="100" src="{{ $s3Url }}" alt="No Image">
                                @else
                                    <img width="auto" height="100"
                                        src="{{ asset('storage/customer_profile_picture/' . $r->clientsinfo->customer_profile_picture) }}"
                                        alt="No Image">
                                @endif
                                <label for="customer_profile_picture" class="block pt-2">
                                    Profile Picture
                                    {{ checkRequired('customer_profile_picture', '*') }}
                                </label>
                                <input type="file" name="customer_profile_picture" accept="image/*"
                                    class="form-control-file"
                                    @if ($r->clientsinfo->customer_profile_picture == null) {{ checkRequired('customer_profile_picture', 'required') }} @endif>
                            </div>
                            <div class="form-group col-sm-2">
                                <div class="text-center mb-1 image-info"></div>
                                @if (checkSettings('store_image_to_s3') == 'enable')
                                    @php
                                        $s3Url = Storage::disk('s3')->url(
                                            'customer_agrement/' . $r->clientsinfo->customer_agrement,
                                        );
                                    @endphp

                                    <img width="auto" height="100" src="{{ $s3Url }}" alt="No Image">
                                @else
                                    <img width="auto" height="100"
                                        src="{{ asset('storage/customer_agrement/' . $r->clientsinfo->customer_agrement) }}"
                                        alt="No Image">
                                @endif

                                <label for="customer_agrement" class="block pt-2">
                                    Customer Agrement{{ checkRequired('customer_agrement_required', '*') }}
                                </label>
                                <input type="file" name="customer_agrement" accept="image/*" class="form-control-file"
                                    @if ($r->clientsinfo->customer_agrement == null) {{ checkRequired('customer_agrement_required', 'required') }} @endif>
                            </div>
                            <div class="form-group col-sm-2">
                                <div class="text-center mb-1 image-info"></div>
                                @if (checkSettings('store_image_to_s3') == 'enable')
                                    @php
                                        $s3Url = Storage::disk('s3')->url(
                                            'profilePicture/' . $r->clientsinfo->profilePicture,
                                        );
                                    @endphp

                                    <img width="auto" height="100" src="{{ $s3Url }}" alt="No Image">
                                @else
                                    <img width="auto" height="100"
                                        src="{{ asset('storage/profilePicture/' . $r->clientsinfo->profilePicture) }}"
                                        alt="No Image">
                                @endif
                                <label for="profilePicture" class="block pt-2">
                                    Picture
                                </label>
                                <input type="file" name="profilePicture" accept="image/*" class="form-control-file">
                            </div>

                            <div class="form-group col-sm-2">
                                <div class="text-center mb-1 image-info"></div>
                                @if (checkSettings('store_image_to_s3') == 'enable')
                                    @php
                                        $s3Url = Storage::disk('s3')->url('picture/' . $r->clientsinfo->picture);
                                    @endphp

                                    <img width="auto" height="100" src="{{ $s3Url }}" alt="No Image">
                                @else
                                    <img width="auto" height="100"
                                        src="{{ asset('storage/picture/' . $r->clientsinfo->picture) }}" alt="No Image">
                                @endif
                                <label for="picture" class="block pt-2">
                                    Building Photo{{ checkRequired('building_photo_required', '*') }}
                                </label>
                                <input type="file" name="picture" accept="image/*" class="form-control-file"
                                    @if ($r->clientsinfo->picture == null) {{ checkRequired('building_photo_required', 'required') }} @endif>
                            </div>

                            <div class="form-group col-sm-2">
                                <div class="text-center mb-1 image-info"></div>
                                @if (checkSettings('store_image_to_s3') == 'enable')
                                    @php
                                        $s3Url = Storage::disk('s3')->url(
                                            'client_door/' . $r->clientsinfo->client_door,
                                        );
                                    @endphp

                                    <img width="auto" height="100" src="{{ $s3Url }}" alt="No Image">
                                @else
                                    <img width="auto" height="100"
                                        src="{{ asset('storage/client_door/' . $r->clientsinfo->client_door) }}"
                                        alt="No Image">
                                @endif
                                <label for="client_door" class="block pt-2">
                                    Client Flat Door Picture{{ checkRequired('dore_picture_required', '*') }}
                                </label>
                                <input type="file" name="client_door" accept="image/*" class="form-control-file"
                                    @if ($r->clientsinfo->client_door == null) {{ checkRequired('dore_picture_required', 'required') }} @endif>
                            </div>

                            <div class="form-group col-sm-2">
                                <div class="text-center mb-1 image-info"></div>
                                @if (checkSettings('store_image_to_s3') == 'enable')
                                    @php
                                        $s3Url = Storage::disk('s3')->url(
                                            'onu_router_info/' . $r->clientsinfo->onu_router_info,
                                        );
                                    @endphp

                                    <img width="auto" height="100" src="{{ $s3Url }}" alt="No Image">
                                @else
                                    <img width="auto" height="100"
                                        src="{{ asset('storage/onu_router_info/' . $r->clientsinfo->onu_router_info) }}"
                                        alt="No Image">
                                @endif
                                <label for="onu_router_info" class="block pt-2">
                                    Onu and Router Info{{ checkRequired('onu_router_info', '*') }}
                                </label>
                                <input type="file" name="onu_router_info" accept="image/*" class="form-control-file"
                                    @if ($r->clientsinfo->client_door == null) {{ checkRequired('onu_router_info', 'required') }} @endif>
                            </div>
                        </div>
                    @endif
                @endif

                <div class="bg-primary">
                    <h4 style="text-align: center;">Service Information</h4>
                </div>
                @if (checkAPI())
                    <div class="form-group">
                        @can('ignore-mikrotik-check')
                            <label class="block">
                                Ignore Mikrotik Check <input name="ignoreMkCheck" type="checkbox"
                                    {{ $r->ignoreMKCheck == 1 ? 'checked' : null }}>
                            </label>
                        @endcan
                        @if (Auth::user()->can('static_manage'))
                            <label class="block @if (!$r->isStatic) d-none @endif">
                                Static IP <input name="isStatic" type="checkbox"
                                    {{ $r->isStatic == 1 ? 'checked' : null }} disabled>
                            </label>
                        @endif

                    </div>
                @endif

                <div class="row">
                    @can('pop_change_on_client_edit')
                        <div class="form-group col-sm-3">
                            <label for="pop_id">
                                Pop Name*
                            </label>
                            <select name="pop_id" id="pop_id" class="form-control select2">
                                <option value="">Select Pop</option>
                                @foreach ($pop as $p)
                                    <option class="p-5" value="{{ $p->id }}"
                                        data-billgenerate="{{ $p->bill_generate }}"
                                        @if ($p->id == $r->pop_id) selected @endif>{{ $p->popname }}</option>
                                @endforeach
                            </select>
                            @error('pop_id')
                                <div class="alert alert-danger mt-1">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    @else
                        <div class="form-group col-sm-3">
                            <label for="pop_id">
                                Pop Name*
                            </label>
                            <input type="text" name="pop_name" id="pop_name" value="{{ $r->pop->popname }}"
                                class="form-control " placeholder="Pop Name" readonly>
                            <input type="hidden" name="pop_id" id="pop_id" value="{{ $r->pop_id }}">

                        </div>
                    @endcan
                    <div class="form-group col-sm-3 @if ($r->isStatic) d-none @endif">
                        <label for="userid" class="">User Name*</label>
                        <input type="hidden" name="olduserid" id="olduserid" value="{{ $r->userid }}">
                        <input type="text" name="userid" id="userid" value="{{ $r->userid }}"
                            class="form-control" placeholder="User Name"
                            @cannot('client-username-edit')
                                    readonly
                                @endcannot>
                        <div id="useridWarning"></div>
                        @error('userid')
                            <div class="alert alert-danger mt-1"> {{ $message }} </div>
                        @enderror
                    </div>
                    <div class="form-group col-sm-3 @if ($r->isStatic) d-none @endif">
                        <label for="password" class="">
                            Password*
                        </label>
                        <input type="text" name="password" id="password" value="{{ $r->password }}"
                            class="form-control " placeholder="Password">
                        @error('password')
                            <div class="alert alert-danger mt-1">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                    @if (checkSettings('customer_code') == 'enable')
                        <div class="form-group col-sm-3">
                            <label for="password" class="block text-sm font-medium text-gray-700">
                                Customer Code @if (checkSettings('customer_code') == 'enable')
                                    *
                                @endif
                            </label>
                            <input type="hidden" name="oldcustomer_code" id="oldcustomer_code"
                                value="{{ $r->customer_code }}">
                            <input type="text" name="customer_code" id="customer_code"
                                value="{{ $r->customer_code }}" class="form-control"
                                @if (checkSettings('customer_code') == 'enable') required @endif placeholder="customer code">
                            <div id="customerCodeWarning"></div>
                            @error('customer_code')
                                <div class="alert alert-danger mt-1">{{ $message }}</div>
                            @enderror
                        </div>
                    @endif
                    <div class="form-group col-sm-3">
                        <label for="package_id" class="">
                            Package Name*
                        </label>
                        <input type="text" name="package_name" id="package_name"
                            value="{{ $r->packages->package_name }}" class="form-control " placeholder="Package Name"
                            readonly>
                    </div>

                    <div class="form-group col-sm-3">
                        <label for="mac" class="">
                            Enable MAC
                        </label>
                        <input type="text" name="mac" id="mac" value="{{ $r->mac ?? '' }}"
                            class="form-control " placeholder="Enable Mac">
                        @error('mac')
                            <div class="alert alert-danger mt-1">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group col-sm-6">

                        <div class="row">
                            <div class="col-sm-6">
                                <label for="password" class="">
                                    Expired Date
                                </label>
                                <input type="text" name="expire_date" id="expire_date"
                                    value="{{ $r->expire_date ?? '' }}" class="form-control " placeholder="Expire Date"
                                    readonly>
                            </div>

                            @if (auth()->user()->can('extend-temporary-dedline'))
                                @if ($r->pops->bill_generate == 'yes')
                                    <div class="col-sm-6">
                                        <label>
                                            Temporary Extend (days)
                                        </label>

                                        <input type="number" min="0"
                                            max="{{ $company_information->max_extended_day ?? 30 }}"
                                            name="payment_dadeline" class="form-control"
                                            placeholder="0 to {{ $company_information->max_extended_day ?? 30 }} days"
                                            value="{{ $r->payment_dadeline }}">
                                    </div>
                                @endif
                            @else
                                <input type="hidden" name="payment_dadeline" value="{{ $r->payment_dadeline }}"
                                    class="form-control">
                            @endif

                        </div>

                    </div>

                    @if (checkSettings('static_ip_manage') == 'enable' && $r->isStatic)
                        <div class="form-group col-sm-3">
                            <label for="" class="block text-sm font-medium text-gray-700">
                                Interface / Ip Block
                            </label>
                            <select name="ethernet_port" id="port" class="form-control select2">
                                <option value="">Select Ethernet Port</option>
                                @foreach ($datas as $data)
                                    <option value="{{ $data->id }}"
                                        @if ($data->id == $r->ethernet_port) selected @endif>
                                        {{ $data->port }}-{{ $data->ip_block }}</option>
                                @endforeach
                            </select>

                            @error('port')
                                <div class="alert alert-danger mt-1">
                                    {{ $message }}
                                </div>
                            @enderror
                        </div>
                    @endif

                    <div class="form-group col-sm-3">
                        <label for="client_name" class="block">
                            Static IP
                        </label>


                        @if (!checkAPI())
                            <input type="text" name="ip_address" id="ip_address" value="{{ $r->ip_address }}"
                                class="form-control " placeholder="Static IP">
                            @error('ip_address')
                                <div class="alert alert-danger mt-1">{{ $message }}</div>
                            @enderror
                        @else
                            @if (checkSettings('static-ip-check') == 'enable')
                                <select class="form-control" name="ip_address" id="static_ip">
                                    @if (isset($r->ip_address))
                                        <option selected value="{{ $r->ip_address }}">{{ $r->ip_address }}</option>
                                    @else
                                        <option selected value="">Select Static IP</option>
                                    @endif
                                    {!! $ip !!}
                                </select>
                            @elseif(checkSettings('static_ip_manage') == 'enable')
                                <select class="form-control" name="ip_address" id="static_ip">
                                    @if (isset($r->ip_address))
                                        <option selected value="{{ $r->ip_address }}">{{ $r->ip_address }}</option>
                                    @else
                                        <option selected value="">Select Static IP</option>
                                    @endif
                                    {!! $ip !!}
                                </select>
                            @else
                                <input type="text" name="ip_address" id="ip_address" value="{{ $r->ip_address }}"
                                    class="form-control " placeholder="Static IP">
                                @error('ip_address')
                                    <div class="alert alert-danger mt-1">{{ $message }}</div>
                                @enderror
                            @endif

                        @endif

                    </div>

                    @if (checkSettings('radius_customer_bandwidth_limit') == 'enable')
                        @if (auth()->user()->can('apply-bandwidth-limit'))
                            <div class="form-group col-sm-3" id="">
                                <label for="bandwidth_limit" class="block">
                                    Bandwidth Limit Extra (MB)
                                </label>
                                <input type="number" step=".01" name="bandwidth_limit" id="bandwidth_limit"
                                    value="{{ $r->bandwidth_limit }}" class="form-control "
                                    placeholder="Bandwidth Limit Extra In MB">
                                @error('bandwidth_limit')
                                    <div class="alert alert-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        @else
                            <input type="hidden" name="bandwidth_limit" id="bandwidth_limit"
                                value="{{ $r->bandwidth_limit }}" readonly class="form-control"
                                placeholder="Bandwidth Limit">
                        @endif
                    @endif

                    @if (checkSettings('parmanent-discount') == 'enable' && $r->pop->bill_generate == 'yes')
                        @if (auth()->user()->can('parmanent-discount'))
                            <div class="form-group col-sm-3">
                                <label for="mac" class="block ">
                                    Parmanent Discount Amount
                                </label>

                                <input type="text" name="parmanent_discount" value="{{ $r->parmanent_discount }}"
                                    class="form-control " placeholder="Discount Amount">
                                @error('mac')
                                    <div class="alert alert-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        @else
                            <input type="hidden" name="parmanent_discount" value="{{ $r->parmanent_discount }}"
                                class="form-control">
                        @endif
                    @endif

                    @if (checkSettings('customer-id-insert') == 'enable')
                        <div class="form-group col-sm-3" id="customer_id">
                            <label for="client_name" class="block">
                                Customer ID
                            </label>

                            <input type="text" name="customer_id" id="customer_id" value="{{ $r->customer_id }}"
                                class="form-control " placeholder="Customer ID" required>
                            @error('customer_id')
                                <div class="alert alert-danger mt-1">{{ $message }}</div>
                            @enderror
                        </div>
                    @endif

                    <div class="form-group col-sm-3">
                        <label for="distribution_point" class="block">
                            Distribution Point @if (checkSettings('btrc_report_field_required') == 'enable')
                                *
                            @endif
                        </label>
                        <select name="distribution_point" id="" class="form-control select2"
                            @if (checkSettings('btrc_report_field_required') == 'enable') required @endif>
                            <option value="">Select One</option>
                            <option value="pop" {{ $r->distribution_point == 'pop' ? 'selected' : '' }}>POP</option>
                            <option value="noc" {{ $r->distribution_point == 'noc' ? 'selected' : '' }}>NOC</option>
                        </select>
                        @error('distribution_point')
                            <div class="alert alert-danger mt-1">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="connection_type" class="block">
                            Connection Type @if (checkSettings('btrc_report_field_required') == 'enable')
                                *
                            @endif
                        </label>
                        <select name="connection_type" id="" class="form-control select2"
                            @if (checkSettings('btrc_report_field_required') == 'enable') required @endif>
                            <option value="">Select One</option>
                            <option value="shared" {{ $r->connection_type == 'shared' ? 'selected' : '' }}>Shared</option>
                            <option value="dedicated" {{ $r->connection_type == 'dedicated' ? 'selected' : '' }}>Dedicated
                            </option>
                        </select>
                        @error('connection_type')
                            <div class="alert alert-danger mt-1">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="customer_type" class="block">Client Type @if (checkSettings('btrc_report_field_required') == 'enable')
                                *
                            @endif
                        </label>
                        <select name="customer_type" id="" class="form-control select2"
                            @if (checkSettings('btrc_report_field_required') == 'enable') required @endif>
                            <option value="">Select One</option>
                            <option value="Home" {{ $r->customer_type == 'Home' ? 'selected' : '' }}>Home</option>
                            <option value="Corporate" {{ $r->customer_type == 'Corporate' ? 'selected' : '' }}>Corporate
                            </option>
                        </select>
                        @error('customer_type')
                            <div class="alert alert-danger mt-1">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="bg-primary">
                    <h4 style="text-align: center;">Basic Information</h4>
                </div>
                <div class="row">

                    <div class="form-group col-sm-3">
                        <label for="password" class="">
                            Client Name*
                        </label>
                        <input type="text" name="client_name" id="client_name" required
                            value="{{ $r->clientsinfo->clients_name }}" class="form-control " placeholder="Client Name">
                        @error('client_name')
                            <div class="alert alert-danger mt-1">{{ $message }}</div>
                        @enderror
                    </div>

                    @if (auth()->user()->can('join-date-modify'))
                        <div class="form-group col-sm-3">
                            <label for="joinDate" class="">
                                Joining Date
                            </label>
                            <div class="input-group date" id="searchFrom2" data-target-input="nearest">
                                <input type="text" placeholder="Joining Date" name="joinDate"
                                    value="{{ $r->clientsinfo->joinDate }}"
                                    class="form-control datetimepicker-input input-group-append"
                                    data-toggle="datetimepicker" data-target="#searchFrom2" autocomplete="off">
                            </div>
                            @error('joinDate')
                                <div class="alert alert-danger mt-1">{{ $message }}</div>
                            @enderror
                        </div>
                    @else
                        <input type="hidden" name="joinDate" value="{{ $r->clientsinfo->joinDate ?? '' }}"
                            class="form-control">
                    @endif

                    <div class="form-group col-sm-3">
                        <label for="password" class="block ">
                            Client DOB
                        </label>
                        <div class="input-group date" id="searchFrom" data-target-input="nearest">
                            <input type="text" placeholder="Client DOB" name="dob"
                                value="{{ $r->clientsinfo->dob }}"
                                class="form-control datetimepicker-input input-group-append" data-toggle="datetimepicker"
                                data-target="#searchFrom" autocomplete="off">
                        </div>
                        @error('dob')
                            <div class="alert alert-danger mt-1">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="father_name" class="">
                            Father Name{{ checkRequired('father-name-required', '*') }}
                        </label>
                        <input type="text" name="father_name" id="father_name"
                            value="{{ $r->clientsinfo->father_name ?? '' }}" class="form-control "
                            placeholder="Father Name" {{ checkRequired('father-name-required', '*') }}>
                        @error('father_name')
                            <div class="alert alert-danger mt-1">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="mother_name" class="">
                            Mother Name {{ checkRequired('mother-name-required', '*') }}
                        </label>
                        <input type="text" name="mother_name" id="mother_name"
                            value="{{ $r->clientsinfo->mother_name ?? '' }}" class="form-control "
                            placeholder="Mother Name" {{ checkRequired('mother-name-required', 'required') }}>
                        @error('mother_name')
                            <div class="alert alert-danger mt-1">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="contact_no" class="">
                            Contact No*
                        </label>
                        <input type="text" name="contact_no" id="contact_no" required
                            value="{{ $r->clientsinfo->contact_no ?? '' }}" class="form-control "
                            placeholder="Contact No">
                        @error('contact_no')
                            <div class="alert alert-danger mt-1">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group col-sm-3">
                        <label for="contact_no" class="block pt-2">
                            Other Contact No
                        </label>
                        <input type="text" name="other_contact" id="other_contact"
                            value="{{ $r->clientsinfo->other_contact ?? '' }}" class="form-control "
                            placeholder="Other Contact No">
                        @error('other_contact')
                            <div class="alert alert-danger mt-1">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group col-sm-3">
                        <label for="email" class="">
                            Email
                        </label>
                        <input type="text" class="form-control" placeholder="email"
                            value="{{ $r->clientsinfo->email ?? '' }}" data-role="tagsinput" id="tags"
                            name="email">
                        @error('email')
                            <div class="alert alert-danger mt-1">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="national_id" class="">
                            National ID @if (checkSettings('national_id') == 'enable')
                                *
                            @endif
                        </label>
                        <input type="text" name="national_id" id="national_id"
                            value="{{ $r->clientsinfo->national_id ?? '' }}" class="form-control "
                            @if (checkSettings('national_id') == 'enable') required @endif placeholder="National ID">
                        @error('national_id')
                            <div class="alert alert-danger mt-1">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="passport_no" class="">
                            Passport No
                        </label>
                        <input type="text" name="passport_no" id="passport_no"
                            value="{{ $r->clientsinfo->passport_no ?? '' }}" class="form-control "
                            placeholder="Passport No">
                        @error('passport_no')
                            <div class="alert alert-danger mt-1">{{ $message }}</div>
                        @enderror
                    </div>
                </div>

                <div class="bg-primary">
                    <h4 style="text-align: center;">Address</h4>
                </div>
                <div class="row">

                    <div class="col-sm-3">
                        <label for="division" class="block pt-2">
                            Division {{ checkSettings('Division') == 'enable' ? '*' : '' }}
                        </label>
                        <select name="division" id="division_id" class="form-control select2"
                            {{ checkSettings('Division') == 'enable' ? 'required' : '' }}>
                            <option value="">Select One</option>
                            @forelse ($division as $item)
                                <option value="{{ $item->id }}"
                                    {{ $item->id == $r->clientsinfo->division ? 'selected' : '' }}>
                                    {{ $item->name }}- {{ $item->bn_name }}</option>
                            @empty
                                <option value="">No Division Found</option>
                            @endforelse
                        </select>
                    </div>
                    <div class="col-sm-3">
                        <label for="district" class="block pt-2">
                            District {{ checkSettings('District') == 'enable' ? '*' : '' }}
                        </label>
                        <select name="district" id="district_id" class="form-control select2"
                            {{ checkSettings('District') == 'enable' ? 'required' : '' }}>
                            <option value="">Select One</option>
                            @if (!empty($r->clientsinfo->district))
                                @foreach ($district as $item)
                                    <option value="{{ $item->id }}"
                                        {{ $item->id == $r->clientsinfo->district ? 'selected' : '' }}>
                                        {{ $item->name }}- {{ $item->bn_name }}</option>
                                @endforeach
                            @endif
                        </select>
                    </div>
                    <div class="col-sm-3">
                        <label for="upazila" class="block pt-2">
                            Upazila {{ checkSettings('Upazila') == 'enable' ? '*' : '' }}
                        </label>
                        <select name="upazila" id="upazila_id" class="form-control select2"
                            {{ checkSettings('Upazila') == 'enable' ? 'required' : '' }}>
                            <option value="">Select One</option>

                            @if (!empty($r->clientsinfo->upazila))
                                @foreach ($upazila as $item)
                                    <option value="{{ $item->id }}"
                                        {{ $item->id == $r->clientsinfo->upazila ? 'selected' : '' }}>
                                        {{ $item->name }}- {{ $item->bn_name }}</option>
                                @endforeach
                            @endif
                            </option>
                        </select>
                    </div>
                    <div class="col-sm-3">
                        <label for="thana" class="block pt-2">
                            Thana {{ checkSettings('Thana') == 'enable' ? '*' : '' }}
                        </label>
                        <select name="thana" id="thana_id" class="form-control select2"
                            {{ checkSettings('Thana') == 'enable' ? 'required' : '' }}>
                            <option value="">Select One</option>

                            {{-- @if (!empty($r->clientsinfo->thana)) --}}
                            @foreach ($thana as $item)
                                <option value="{{ $item->id }}"
                                    {{ $item->id == $r->clientsinfo->thana ? 'selected' : '' }}>
                                    {{ $item->name }}- {{ $item->bn_name }}</option>
                            @endforeach
                            {{-- @endif --}}
                            </option>
                        </select>
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="area" class="pt-2">
                            Area/Union Parishad @if (checkSettings('area') == 'enable')
                                *
                            @endif
                        </label>
                        @if (checkSettings('area-dropdown') == 'enable')
                            <select class="form-control select2" name="area" id="area"
                                {{ checkSettings('area') == 'enable' ? 'required' : '' }}>
                                <option value="">Select One</option>
                                @forelse ($popArea as $item)
                                    <option value="{{ $item->area }}"
                                        {{ $r->clientsinfo->area == $item->area ? 'selected' : '' }}>
                                        {{ $item->area }}</option>
                                @empty
                                @endforelse
                            </select>
                        @else
                            <select name="area_select" id="area_select" class="select2 form-control">
                                <option value="">Select Area</option>
                                @foreach ($areas as $area)
                                    <option value="{{ $area }}">{{ $area }}</option>
                                @endforeach
                            </select>

                            <input type="text" name="area" id="area"
                                value="{{ $r->clientsinfo->area ?? '' }}" class="form-control float-right"
                                placeholder="Area">
                        @endif
                        @error('area')
                            <div class="alert alert-danger mt-1">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="block_sector" class="">
                            Block/Sector/Post Office
                        </label>
                        <input type="text" name="block_sector" id="block_sector"
                            value="{{ $r->clientsinfo->block_sector ?? '' }}" class="form-control "
                            placeholder="Block/Sector">
                        @error('block_sector')
                            <div class="alert alert-danger mt-1">{{ $message }}
                            </div>
                        @enderror
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="road_name" class="">
                            Road Name/Village
                        </label>
                        <input type="text" name="road_name" id="road_name"
                            value="{{ $r->clientsinfo->road_name ?? '' }}" class="form-control "
                            placeholder="Road Name">
                        @error('road_name')
                            <div class="alert alert-danger mt-1">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="road_no" class="">
                            Road No/Ward No
                        </label>
                        <input type="text" name="road_no" id="road_no"
                            value="{{ $r->clientsinfo->road_no ?? '' }}" class="form-control " placeholder="Road No">
                        @error('road_no')
                            <div class="alert alert-danger mt-1">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="building_name" class="">
                            Building Name{{ checkRequired('bulling_name', '*') }}
                        </label>
                        <input type="text" name="building_name" id="building_name"
                            value="{{ $r->clientsinfo->building_name ?? '' }}" class="form-control "
                            placeholder="Building Name" {{ checkRequired('bulling_name', 'required') }}>
                        @error('building_name')
                            <div class="alert alert-danger mt-1">{{ $message }}
                            </div>
                        @enderror
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="password" class="">
                            Building No
                        </label>
                        <input type="text" name="building_no" id="building_no"
                            value="{{ $r->clientsinfo->building_no ?? '' }}" class="form-control "
                            placeholder="Building No">
                        @error('building_no')
                            <div class="alert alert-danger mt-1">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="flat_no" class="">
                            Flat/Level No{{ checkRequired('flat_no', '*') }}
                        </label>
                        <input type="text" name="flat_no" id="flat_no"
                            value="{{ $r->clientsinfo->flat_no ?? '' }}" class="form-control " placeholder="Flat No"
                            {{ checkRequired('flat_no', '*') }}>
                        @error('flat_no')
                            <div class="alert alert-danger mt-1">{{ $message }}</div>
                        @enderror
                    </div>

                    <div class="form-group col-sm-3">
                        <label for="owner_name" class="">
                            House Owner Name{{ checkRequired('house_owner_name', '*') }}
                        </label>
                        <input type="text" name="owner_name" id="owner_name"
                            value="{{ $r->clientsinfo->owner_name }}" class="form-control " placeholder="Owner Name"
                            {{ checkRequired('house_owner_name', 'required') }}>
                        @error('owner_name')
                            <div class="alert alert-danger mt-1">{{ $message }}</div>
                        @enderror
                    </div>
                    <div class="form-group col-sm-3">
                        <label for="owner_contact" class="">
                            Owner Contact{{ checkRequired('house_owner_contact', '*') }}
                        </label>
                        <input type="text" name="owner_contact" id="onwer_number"
                            value="{{ $r->clientsinfo->owner_number }}" class="form-control "
                            placeholder="Owner Contact" {{ checkRequired('house_owner_contact', 'required') }}>
                        @error('onwer_number')
                            <div class="alert alert-danger mt-1">{{ $message }}
                            </div>
                        @enderror
                    </div>

                    @if (checkSettings('box') == 'disable')
                        <div class="col-sm-3">
                            <label for="area" class="block pt-2">
                                Box
                            </label>
                            <input type="text" name="box" id="box" value="{{ $r->clientsinfo->box }}"
                                class="form-control " placeholder="box">
                        </div>
                    @endif
                    @if (checkSettings('box') == 'enable')
                        <div class="col-sm-3">
                            <label class="block pt-2">
                                Box id
                            </label>
                            <select name="box_id" id="box_id" class="form-control">
                                <option value="">Select Box</option>
                                @foreach ($boxs as $item)
                                    <option value="{{ $item->id }}"
                                        {{ $item->id == $r->box_id ? 'selected' : '' }}>
                                        {{ $item->box_name }}</option>
                                @endforeach
                            </select>
                        </div>
                    @endif

                    @if (globalPermission('manage-map'))
                        <div class="col-sm-3">
                            <label for="map_box_id" class="block pt-2">
                                Map Box
                            </label>
                            <select name="map_box_id" id="map_box" class="form-control select2">

                            </select>
                        </div>
                    @endif

                    <div class="col-sm-3">
                        <label for="latitude" class="block pt-2">
                            Latitude
                        </label>
                        <input type="text" name="client_latitude" id="client_latitude"
                            value="{{ $r->clientsinfo->client_latitude }}" class="form-control "
                            placeholder="latitude">
                    </div>
                    <div class="col-sm-3">
                        <label for="longitude" class="block pt-2">
                            Longitude
                        </label>
                        <input type="text" name="client_longitude" id="client_longitude"
                            value="{{ $r->clientsinfo->client_longitude }}" class="form-control "
                            placeholder="longitude">
                    </div>
                </div>

                <div class="bg-primary mt-3">
                    <h4 style="text-align: center;">Connection Information</h4>
                </div>
                <div class="row">

                    <div class="row" id="connection_info">
                        <div class="form-group col-sm-2">
                            <label for="passport_no" class="block pt-2">
                                Cable type{{ checkRequired('cable-meter-required', '*') }}
                            </label>
                            <select name="cable_type" id="cable_type" class="form-control form-control-sm select2"
                                {{ checkRequired('cable_meter_required', 'required') }}>
                                <option value="">Select Cable Core Type</option>
                                <option value="fiber_optic_2_core" @if ($r->clientsinfo->cable_type == 'fiber_optic_2_core') selected @endif>
                                    Fiber
                                    Optic 2 Core
                                </option>
                                <option value="fiber_optic_4_core" @if ($r->clientsinfo->cable_type == 'fiber_optic_4_core') selected @endif>
                                    Fiber
                                    Optic 4 Core
                                </option>
                                <option value="fiber_optic_6_core" @if ($r->clientsinfo->cable_type == 'fiber_optic_6_core') selected @endif>
                                    Fiber
                                    Optic 6 Core
                                </option>
                                <option value="fiber_optic_8_core" @if ($r->clientsinfo->cable_type == 'fiber_optic_8_core') selected @endif>
                                    Fiber Optic 8 Core
                                </option>
                                <option value="fiber_optic_12_core" @if ($r->clientsinfo->cable_type == 'fiber_optic_12_core') selected @endif>
                                    Fiber Optic 12 Core
                                </option>
                                <option value="fiber_optic_24_core" @if ($r->clientsinfo->cable_type == 'fiber_optic_24_core') selected @endif>
                                    Fiber Optic 24 Core
                                </option>
                            </select>
                        </div>

                        @if (auth()->user()->can('edit_cable_meter'))
                            <div class="form-group col-sm-1">
                                <label for="from_cable"
                                    class="block pt-2">From:{{ checkRequired('cable_meter_from', '*') }}</label>
                                <input type="number" min="0" name="from_cable" id="from_cable"
                                    value="{{ $r->clientsinfo->from_cable }}" class="form-control form-control-sm "
                                    placeholder="Start Number" {{ checkRequired('cable_meter_from', 'required') }}>
                            </div>
                            <div class="form-group col-sm-1">
                                <label for="to_cable"
                                    class="block pt-2">To:{{ checkRequired('cable_meter_to', '*') }}</label>
                                <input type="number" min="0" name="to_cable" id="to_cable"
                                    value="{{ $r->clientsinfo->to_cable }}" class="form-control form-control-sm "
                                    placeholder="End Number" {{ checkRequired('cable_meter_to', 'required') }}>
                            </div>
                            <div class="form-group col-sm-1">
                                <label for="from_cable2" class="block pt-2">From(2nd):</label>
                                <input type="number" min="0" name="from_cable2" id="from_cable2"
                                    value="{{ $r->clientsinfo->from_cable2 }}" class="form-control form-control-sm "
                                    placeholder="Start Number">
                            </div>
                            <div class="form-group col-sm-1">
                                <label for="to_cable2" class="block pt-2">To(2nd):</label>
                                <input type="number" min="0" name="to_cable2" id="to_cable2"
                                    value="{{ $r->clientsinfo->to_cable2 }}" class="form-control form-control-sm "
                                    placeholder="End Number">
                            </div>
                            <div class="form-group col-sm-2">
                                <label for="total" class="block pt-2">Total Cable(Meter)</label>
                                <input type="text" value="{{ $r->required_cable }}" id="total_cable_meter"
                                    name="required_cable" class="form-control form-control-sm">
                            </div>
                            <div class="form-group col-sm-2">
                                <label for="cable_id" class="block pt-2">Cable ID
                                    {{ checkRequired('cable_id_required', '*') }}</label>
                                <input type="text" name="cable_id" id="cable_id"
                                    value="{{ $r->clientsinfo->cable_id ?? '' }}" class="form-control  form-control-sm"
                                    placeholder="Cable ID" {{ checkRequired('cable_id_required', 'required') }}>
                                @error('cable_id')
                                    <div class="alert alert-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        @else
                            <input type="hidden" name="from_cable" value="{{ $r->clientsinfo->from_cable ?? '' }}"
                                class="form-control">
                            <input type="hidden" name="to_cable" value="{{ $r->clientsinfo->to_cable ?? '' }}"
                                class="form-control">
                            <input type="hidden" name="from_cable2" value="{{ $r->clientsinfo->from_cable2 ?? '' }}"
                                class="form-control">
                            <input type="hidden" name="to_cable2" value="{{ $r->clientsinfo->to_cable2 ?? '' }}"
                                class="form-control">
                            <input type="hidden" name="required_cable" value="{{ $r->required_cable ?? '' }}"
                                class="form-control">
                            <input type="hidden" name="cable_id" value="{{ $r->clientsinfo->cable_id ?? '' }}"
                                class="form-control">
                        @endif

                        <div class="form-group col-sm-2">
                            <label for="cat_type" class="block pt-2">
                                Cable(CAT-5/CAT-6){{ checkRequired('cable_cat5_cat6_required', '*') }}
                            </label>
                            <select name="cat_type" id="cat_type" class="form-control select2 form-control-sm"
                                {{ checkRequired('cable_cat5_cat6_required', 'required') }}>
                                <option value="">Select Cable Type</option>
                                <option value="cat5" {{ $r->clientsinfo->cat_type == 'cat5' ? 'selected' : '' }}>Cat 5
                                </option>
                                <option value="cat6" {{ $r->clientsinfo->cat_type == 'cat6' ? 'selected' : '' }}>Cat 6
                                </option>
                            </select>
                        </div>

                        <div class="form-group col-sm-3">
                            <label for="cat_length" class="block">
                                Cable(CAT-5/CAT-6) Meter {{ checkRequired('cable_cat5_cat6_required', '*') }}
                            </label>
                            <input type="number" min="0" name="cat_length" id="cat_length"
                                value="{{ $r->clientsinfo->cat_length }}" class="form-control  form-control-sm"
                                placeholder="Cable Meter" {{ checkRequired('cable_cat5_cat6_required', 'required') }}>
                            @error('cat_length')
                                <div class="alert alert-danger mt-1">{{ $message }}</div>
                            @enderror
                        </div>

                        @if (checkSettings('olt-pon') == 'enable')
                            <div class="form-group col-sm-3">
                                <label for="onu_serial" class="block">
                                    ONU MAC/Pon No/Serial No {{ checkRequired('onu_serial_required', '*') }}
                                </label>
                                <input type="text" name="onu_serial" id="onu_serial"
                                    value="{{ $r->clientsinfo->onu_serial ?? '' }}"
                                    class="form-control  form-control-sm" placeholder="ONU MAC/Serial No"
                                    {{ checkRequired('onu_serial_required', 'required') }}>
                                @error('onu_serial')
                                    <div class="alert alert-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group col-sm-3">
                                <label for="olt_pon" class="block">
                                    OLT No {{ checkRequired('olt_no_require', '*') }}
                                </label>
                                <input type="text" name="olt_pon" id="olt_pon"
                                    value="{{ $r->clientsinfo->olt_pon ?? '' }}" class="form-control  form-control-sm"
                                    placeholder="Olt No" {{ checkRequired('olt_no_require', 'required') }}>
                                @error('olt_pon')
                                    <div class="alert alert-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group col-sm-3">
                                <label for="olt_no" class="block">
                                    OLT Card Slot Number {{ checkRequired('olt_port_number_required', '*') }}
                                </label>
                                <input type="text" name="olt_no" id="olt_no"
                                    value="{{ $r->clientsinfo->olt_no }}" class="form-control form-control-sm "
                                    placeholder="OLT Card Slot Number"
                                    {{ checkRequired('olt_port_number_required', 'required') }}>
                                @error('olt_no')
                                    <div class="alert alert-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>

                            <div class="form-group col-sm-3">
                                <label for="pon_port" class="block">
                                    PON Module Port No {{ checkRequired('pon_module_required', '*') }}
                                </label>
                                <input type="text" name="pon_port" id="pon_port"
                                    value="{{ $r->clientsinfo->pon_port }}" class="form-control"
                                    placeholder="PON Module Port No"
                                    {{ checkRequired('pon_module_required', 'required') }}>
                                @error('pon_port')
                                    <div class="alert alert-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        @endif

                        @if (checkSettings('local-user-first-approve') == 'enable')
                            <div class="form-group col-sm-3">
                                <label for="marketed_by" class="block">
                                    Marketed By
                                </label>
                                @if (auth()->user()->can('change_marketed_by'))
                                    <div class="col-sm-12" id="marketedDiv">
                                        <select name="marketed_by" id="marketed_by" class="form-control select2">
                                            <option value="">Select Marketer</option>
                                            @forelse ($marketer as $m)
                                                <option value="{{ $m->id }}"
                                                    {{ $m->id == $r->marketed_by ? 'selected' : '' }}>
                                                    {{ $m->firstname }}
                                                    {{ $m->lastname }}
                                                </option>
                                            @empty
                                            @endforelse
                                        </select>
                                    </div>
                                @else
                                    <input type="hidden" name="marketed_by" value="{{ $r->marketed_by ?? '' }}"
                                        class="form-control">
                                    <div class="col-sm-12">
                                        <select class="form-control" disabled>
                                            <option value="">Select One</option>
                                            @forelse ($marketer as $m)
                                                <option value="{{ $m->id }}"
                                                    {{ $m->id == $r->marketed_by ? 'selected' : '' }}>
                                                    {{ $m->firstname }}
                                                    {{ $m->lastname }}
                                                </option>
                                            @empty
                                            @endforelse
                                        </select>
                                    </div>
                                @endif
                                {{-- @endif --}}
                            </div>
                        @else
                            <input type="hidden" name="marketed_by" value="{{ $r->marketed_by ?? '' }}"
                                class="form-control">
                        @endif
                        @if (checkSettings('source_name') == 'enable')
                            <div class="form-group col-sm-3">
                                <label for="marketed_by" class="block">
                                    Source Name
                                </label>
                                <div class="" id="">
                                    <select name="source_name" id="source_name" class="form-control select2">
                                        <option value="">Select One</option>
                                        @forelse ($client_source as $source)
                                            <option value="{{ $source->id }}"
                                                {{ $r->clientsinfo->source_name == $source->id ? 'selected' : '' }}>
                                                {{ $source->name }}</option>
                                        @empty
                                        @endforelse
                                    </select>
                                </div>
                                @error('source_name')
                                    <div class="alert alert-danger mt-1">{{ $message }}</div>
                                @enderror
                            </div>
                        @endif
                        <div class="form-group col-sm-3">
                            <label for="required_cable" class="">OTC</label>
                            <input type="text" min="0" name="otc" id="otc"
                                value="{{ $r->clientsinfo->otc ?? '' }}" class="form-control " placeholder="otc"
                                readonly>
                            @error('otc')
                                <div class="alert alert-danger mt-1">{{ $message }}
                                </div>
                            @enderror
                        </div>
                        @if (checkSettings('free_client') == 'enable')
                            @can('free-client')
                                <div class="form-group col-sm-3">
                                    <label for="billing_cycle" class="block ">
                                        Free CLient
                                    </label>
                                    <select name="is_free" id="is_free" class="form-control" required>
                                        <option {{ $r->is_free == 0 ? 'selected' : '' }} value="0">No</option>
                                        <option {{ $r->is_free == 1 ? 'selected' : '' }} value="1">Yes</option>
                                    </select>
                                </div>
                            @endcan
                        @endif
                        @if (checkSettings('setClientPaymentAmountToClient') == 'enable')
                            <div class="form-group col-md-4" id="clientPaymentContainer"
                                style="display: @if ($r->pops->bill_generate != 'yes') @else none @endif">
                                <label for="pool_name" class="block text-sm font-medium text-gray-700">
                                    Client payment amount
                                </label>
                                <input type="number" name="client_payment_amount" id="client_payment_amount"
                                    class="focus:ring-indigo-500 focus:border-indigo-500 form-control"
                                    placeholder=" Client payment amount" value="{{ $r->client_payment_amount }}"
                                    autocomplete="off">
                                @error('client_payment_amount')
                                    <div class="alert alert-danger">
                                        {{ $message }}
                                    </div>
                                @enderror
                            </div>
                        @endif
                        <div class="form-group col-sm-12">
                            <label for="contact_no" class="">Remarks</label>
                            <textarea name="remarks" id="remarks" class="form-control">{{ $r->clientsinfo->remarks ?? '' }}</textarea>
                            @error('remarks')
                                <div class="alert alert-danger mt-1">{{ $message }}</div>
                            @enderror
                        </div>
                    </div>
                </div>

                <div class="form-group col-sm-4 float-right">
                    <div class="mt-5 mr-1 row float-right">
                        <a href="{{ route('clients.index') }}"><button type="button"
                                class="btn btn-primary">Back</button></a>
                        <button type="submit" id="updateBtn" class="btn btn-success ml-1">Update Client
                            Info</button>
                    </div>
                </div>
            </div>
        </div>
    </form>


    <div class="modal fade" id="mapModal" tabindex="-1" role="dialog" aria-labelledby="mapModalLabel">
        <div class="modal-dialog modal-xl" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="mapModalLabel">Select Client Location</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div id="map" style="height:500px;"></div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">Close</button>
                    <button type="button" class="btn btn-primary" id="save-location-btn">Save Location</button>
                </div>
            </div>
        </div>
    </div>

    <div class="modal fade" id="imageModal" tabindex="-1" role="dialog" aria-labelledby="imageModalLabel">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="imageModalLabel">Image Preview</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body text-center">
                    <img id="modalImage" src="" alt="Full size image" style="max-width: 100%; height: auto;">
                </div>
            </div>
        </div>
    </div>

@endsection

@push('js')
    <script src="{{ asset('taginput/bootstrap-tagsinput.js') }}"></script>
@endpush

@section('ajax')
    <script type="text/javascript">
        $(function() {

            $('#paymentDate').datetimepicker({
                format: 'L'
            });

            var macAddress = $("#mac");

            macAddress.on("keyup", formatMAC);

            $('#port').on('change', function() {
                let pop = $('#pop_id').val();
                let id = $(this).val();
                $.ajax({
                    type: 'get',
                    url: '{{ route('getStaticIpRange') }}',
                    data: {
                        id: id,
                        pop: pop
                    },
                    success: function(data) {
                        $('#static_ip').html(
                            '<option value="{{ $r->ip_address }}">{{ $r->ip_address }}</option>' +
                            data
                        );
                    }
                });

            });

            $('#userid').on('change', function() {
                let olduserid = $('#olduserid').val();
                let userid = $(this).val();

                if (olduserid == userid) {
                    $('#updateBtn').show();
                    $('#userid').css('border', '1px solid #ddd');
                    $('#useridWarning').html('<span></span>');
                } else {

                    $.ajax({
                        type: 'get',
                        url: '{{ route('checkUsernameOnEdit') }}',
                        data: {
                            username: userid
                        },
                        success: function(data) {

                            if (data != true) {

                                $('#updateBtn').hide();
                                $('#userid').css('border', '1px solid red');
                                $('#useridWarning').html(
                                    '<span style="color:red">Not Available</span>');
                            } else {
                                $('#updateBtn').show();
                                $('#userid').css('border', '1px solid #ddd');
                                $('#useridWarning').html(
                                    '<span style="color:green">Available</span>');
                            }
                        }
                    });
                }
            });

            $('#customer_code').on('change', function() {
                let oldcustomerCode = $('#oldcustomer_code').val();
                let customerCode = $(this).val();

                if (oldcustomerCode == customerCode) {
                    $('#updateBtn').show();
                    $('#customer_code').css('border', '1px solid #ddd');
                    $('#customerCodeWarning').html('<span></span>');
                } else {
                    $.ajax({
                        type: 'get',
                        url: '{{ route('checkCustomerCode') }}',
                        data: {
                            customerCode: customerCode
                        },
                        success: function(data) {
                            if (data != true) {
                                $('#updateBtn').hide();
                                $('#customer_code').css('border', '1px solid red');
                                $('#customerCodeWarning').html(
                                    '<span style="color:red">Not Available</span>');
                            } else {
                                $('#updateBtn').show();
                                $('#customer_code').css('border', '1px solid #ddd');
                                $('#customerCodeWarning').html(
                                    '<span style="color:green">Available</span>');
                            }
                        }
                    });
                }
            });

            $('#cable_type').on('change', function() {
                let cat_type = $('#cat_type');
                let cat_length = $('#cat_length');
                cat_type.prop("required", false);
                cat_length.prop("required", false);
            });

            $('#cat_type').on('change', function() {
                let cat_length = $('#cat_length');
                cat_length.prop("required", true);
                let cable_type = $('#cable_type');
                cable_type.prop("required", false);
            });



            $('#from_cable').on('change', function() {
                var from_cable = $('#from_cable').val();
                var to_cable = $('#to_cable').val();
                calculateCableMeter(from_cable, to_cable);
            });

            $('#to_cable').on('change', function() {
                var from_cable = $('#from_cable').val();
                var to_cable = $('#to_cable').val();
                calculateCableMeter(from_cable, to_cable);
            });

            $('#from_cable2').on('keyup', function() {
                var from_cable2 = $('#from_cable2').val();
                var to_cable2 = $('#to_cable2').val();
                calculateCableMeter2(from_cable2, to_cable2);
            });

            $('#to_cable2').on('keyup', function() {
                var from_cable2 = $('#from_cable2').val();
                var to_cable2 = $('#to_cable2').val();
                calculateCableMeter2(from_cable2, to_cable2);
            });

            var difference1 = 0;
            var difference2 = 0;

            function calculateCableMeter($start, $end) {
                // $('#total_cable_meter').val(Math.abs($start - $end));
                difference1 = Math.abs($start - $end);
                $('#total_cable_meter').val(difference1 + difference2);
            }

            function calculateCableMeter2($start, $end) {
                difference2 = Math.abs($start - $end);
                $('#total_cable_meter').val(difference1 + difference2);
            }


            $('#pop_id').on('change', function() {
                let id = $(this).val();
                let billGenerateinfo = $(this).find(':selected').data('billgenerate');
                console.log(billGenerateinfo);


                if (billGenerateinfo == 'yes') {
                    $('#clientPaymentContainer').hide();
                } else {
                    $('#clientPaymentContainer').show();
                }

                $.ajax({
                    type: 'get',
                    url: '{{ route('getPackageForPop') }}',
                    data: {
                        id: id
                    },
                    success: function(data) {
                        $('#package_id option').remove();
                        $('#package_id').append(data);
                    }
                });


                $.ajax({
                    type: 'get',
                    url: '{{ route('getResellerArea') }}',
                    data: {
                        id: $(this).val()
                    },
                    success: function(result) {
                        $('#area').html(result);
                    }
                });

                $.ajax({
                    type: 'get',
                    url: '{{ route('getBox') }}',
                    data: {
                        pop_id: $(this).val()
                    },
                    success: function(data) {
                        $('#box_id').html(
                            '<option selected value="">Select Box</option>' +
                            data
                        );

                    }
                })
            })

        });

        // for area select
        $('#area_select').on('change', function() {
            var area = $('#area_select').val();
            $('#area').val(area);
        });


        function formatMAC(e) {
            var r = /([a-f0-9]{2})([a-f0-9]{2})/i,
                str = e.target.value.replace(/[^a-f0-9]/ig, "");

            while (r.test(str)) {
                str = str.replace(r, '$1' + ':' + '$2');
            }

            e.target.value = str.slice(0, 17);
        };
    </script>
    <script>
        $('document').ready(function() {

            $('#division_id').change(function() {
                var id = $('#division_id').val();
                $.ajax({
                    url: '{{ route('fetchDistrict') }}',
                    type: 'get',
                    data: {
                        id: id
                    },
                    dataType: 'json',
                    success: function(data) {
                        $('#district_id').html(data);
                    }
                });
            });

            $('#district_id').change(function() {
                var id = $('#district_id').val();
                $.ajax({
                    url: '{{ route('fetchUpazila') }}',
                    type: 'get',
                    data: {
                        id: id
                    },
                    dataType: 'json',
                    success: function(data) {
                        $('#upazila_id').html(data);
                    }
                });
            });

            $('#upazila_id').change(function() {
                var id = $('#upazila_id').val();
                $.ajax({
                    url: '{{ route('fetchThana') }}',
                    type: 'get',
                    data: {
                        id: id
                    },
                    dataType: 'json',
                    success: function(data) {
                        $('#thana_id').html(data);
                    }
                });
            });
        });
    </script>

    <script src="https://maps.googleapis.com/maps/api/js?key={{ env('MIX_MAP_API_KEY') }}&libraries=maps,marker&v=beta"
        defer></script>
    <script type="module">
        $('document').ready(function() {
            $.ajax({
                url: '{{ route('boxes.index') }}',
                type: 'get',
                success: function(data) {
                    console.log(data);
                    $('#map_box').html(
                        `<option value="">Select Box</option>` +
                        data.map(item =>
                            `<option value="${item.id}" ${ {{ $r->clientsinfo->map_box_id ? $r->clientsinfo->map_box_id : 'null' }} === item.id ? 'selected' : ''}>${item.id}.${item.name}</option>`
                        ).join(
                            '')
                    );
                }
            });

            let map;
            let boxMarkar;
            let clientMarkar;

            $('#map_box').on('change', async function() {
                const boxId = $(this).val();

                const box = await fetch(`{{ route('boxes.coordinates', '') }}/${boxId}`);
                const boxCordinate = await box.json();
                const latLong = JSON.parse(boxCordinate.coordinates);


                async function initMap() {
                    map = new google.maps.Map(document.getElementById('map'), {
                        center: latLong,
                        zoom: 17,
                        mapId: "select_location_client"
                    });

                    boxMarkar = new google.maps.Marker({
                        map,
                        position: latLong,
                        icon: "/images/box.png",
                    });

                    google.maps.event.addListener(map, 'click', function(event) {
                        placeMarker(event.latLng);
                    });

                    function placeMarker(location) {
                        if (clientMarkar) {
                            clientMarkar.setPosition(location);
                        } else {
                            clientMarkar = new google.maps.Marker({
                                position: location,
                                map: map
                            });
                        }
                    }
                    $("#mapModal").modal('show');
                }

                initMap();

            });

            $('#save-location-btn').on('click', function() {
                if (clientMarkar) {
                    console.log(clientMarkar)
                    const lat = clientMarkar.getPosition().lat();
                    const lng = clientMarkar.getPosition().lng();
                    $('#client_latitude').val(lat);
                    $('#client_longitude').val(lng);

                }

                $("#mapModal").modal('hide');
                map = null;
                boxMarkar = null;
                clientMarkar = null;
            });
        })
    </script>

    <script type="text/javascript">
        // Add image click handler
        $(document).ready(function() {
            // Add click handler to all images in the file_info div
            $('#file_info img').each(function() {
                var img = $(this);
                var infoDiv = img.closest('.form-group').find('.image-info');
                var imgSrc = img.attr('src');

                // Get file extension from src
                var extension = imgSrc.split('.').pop().toLowerCase();

                // Fetch the image file size and dimensions
                fetch(imgSrc)
                    .then(response => {
                        // Get file size from response headers
                        const size = response.headers.get('content-length');
                        let sizeText = '';
                        if (size) {
                            // Convert to MB if larger than 1MB, otherwise show in KB
                            if (size > 1024 * 1024) {
                                sizeText = (size / (1024 * 1024)).toFixed(2) + ' MB';
                            } else {
                                sizeText = (size / 1024).toFixed(2) + ' KB';
                            }
                        }

                        // Create a new image object to get the dimensions
                        var tempImg = new Image();
                        tempImg.onload = function() {
                            var width = this.width;
                            var height = this.height;
                            // Combine size, dimensions and file type
                            var fullText = sizeText + ' (' + width + ' x ' + height + ' px) - ' +
                                extension.toUpperCase();
                            infoDiv.text(fullText);
                        }
                        tempImg.src = imgSrc;
                    })
                    .catch(error => {
                        console.error('Error fetching image:', error);
                    });

                // Add click handler for modal
                img.css('cursor', 'pointer').click(function() {
                    var imgSrc = $(this).attr('src');
                    $('#modalImage').attr('src', imgSrc);
                    $('#imageModal').modal('show');
                });
            });
        });
    </script>
@endsection
