<?php

namespace Database\Seeders;

use App\Models\User;
use App\Models\User_details;
use App\Models\Permission;
use Illuminate\Database\Seeder;
use Spatie\Permission\Models\Role;

class SoftwareAdmin extends Seeder
{
    public function run()
    {
        $data = [
            'name' => 'Software Admin',
            'email' => 'admin@billingfix.xyz',
            'password' => bcrypt('87654321'),
        ];

        if (User::where('email', $data['email'])->count() < 1) {
            $user = User::create($data);
            User_details::create([
                'user_id' => $user->id,
                'user_status' => 'active'
            ]);
        } else {
            $user = User::with('userdetails')->where('email', 'admin@billingfix.xyz')->first();
        }

        if (Role::where('name', 'SoftwareAdmin')->count() < 1) {
            $role = Role::create(['name' => 'SoftwareAdmin']);
        } else {
            $role = Role::where('name', 'SoftwareAdmin')->first();
        }

        $permissions = Permission::pluck('id')->all();
        $role->syncPermissions($permissions);
        $user->assignRole([$role->id]);
    }
}
