@extends('layout.app')
@section('content')
    <form action="{{ route('voice-gateway.store') }}" method="POST">
        @csrf
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="form-group col-md-6">
                        <label for="name" class="block text-sm font-medium text-gray-700">
                            Name <span class="text-danger">*</span>
                        </label>
                        <input type="text" name="name" id="name" value="{{ old('name') }}"
                            class="form-control" placeholder="Voice Gateway Name" autocomplete="off" required>
                        @error('name')
                            <div class="alert alert-danger mt-1">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="form-group col-md-6">
                        <label for="caller_id" class="block text-sm font-medium text-gray-700">
                            Caller ID (DID) <span class="text-danger">*</span>
                        </label>
                        <input type="text" name="caller_id" id="caller_id" value="{{ old('caller_id') }}"
                            class="form-control" placeholder="096xxxxxxxx" autocomplete="off" required>
                        @error('caller_id')
                            <div class="alert alert-danger mt-1">
                                {{ $message }}
                            </div>
                        @enderror
                        <small class="form-text text-muted">The DID from which call will be initiated</small>
                    </div>

                    <div class="form-group col-md-6">
                        <label for="retry_count" class="block text-sm font-medium text-gray-700">
                            Retry Count <span class="text-danger">*</span>
                        </label>
                        <input type="number" name="retry_count" id="retry_count" value="{{ old('retry_count', 0) }}"
                            class="form-control" placeholder="0" min="0" max="5" required>
                        @error('retry_count')
                            <div class="alert alert-danger mt-1">
                                {{ $message }}
                            </div>
                        @enderror
                        <small class="form-text text-muted">Number of retry attempts (0-5)</small>
                    </div>

                    <div class="form-group col-md-6">
                        <label for="username" class="block text-sm font-medium text-gray-700">
                            Username
                        </label>
                        <input type="text" name="username" id="username" value="{{ old('username') }}"
                            class="form-control" placeholder="Username" autocomplete="off">
                        @error('username')
                            <div class="alert alert-danger mt-1">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="form-group col-md-6">
                        <label for="password" class="block text-sm font-medium text-gray-700">
                            Password
                        </label>
                        <input type="text" name="password" id="password" value="{{ old('password') }}"
                            class="form-control" placeholder="Password" autocomplete="off">
                        @error('password')
                            <div class="alert alert-danger mt-1">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="form-group col-md-6">
                        <label for="api_key" class="block text-sm font-medium text-gray-700">
                            API Key
                        </label>
                        <input type="text" name="api_key" id="api_key" value="{{ old('api_key') }}"
                            class="form-control" placeholder="API Key" autocomplete="off">
                        @error('api_key')
                            <div class="alert alert-danger mt-1">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="form-group col-md-12">
                        <label for="api_url" class="block text-sm font-medium text-gray-700">
                            API URL <span class="text-danger">*</span>
                        </label>
                        <input type="text" name="api_url" id="api_url" class="form-control"
                            placeholder="http://example.com/api/do_blast" value="{{ old('api_url') }}" required>
                        @error('api_url')
                            <div class="alert alert-danger mt-1">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="form-group col-md-12">
                        <label for="report_url" class="block text-sm font-medium text-gray-700">
                            Balance API URL
                        </label>
                        <input type="text" name="report_url" id="report_url" class="form-control"
                            placeholder="http://example.com/broadcast/index.php/api/get_balance_info" value="{{ old('report_url') }}">
                        <small class="form-text text-muted">This URL is used to fetch balance information from the API.</small>
                        @error('report_url')
                            <div class="alert alert-danger mt-1">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>

                    <div class="form-group col-md-6">
                        <label for="status" class="block text-sm font-medium text-gray-700">
                            Status
                        </label>
                        <select name="status" id="status" class="form-control select2" required>
                            <option value="">Select One</option>
                            <option value="enable">Enable</option>
                            <option value="disable">Disable</option>
                        </select>
                        @error('status')
                            <div class="alert alert-danger mt-1">
                                {{ $message }}
                            </div>
                        @enderror
                    </div>
                </div>
                <div class="form-group">
                    <button type="submit" class="btn btn-primary float-right">Save</button>
                </div>
            </div>
        </div>
    </form>
@endsection

