<?php

namespace App\Exports;

use Maatwebsite\Excel\Concerns\FromCollection;
use Carbon\Carbon;
use Maatwebsite\Excel\Concerns\WithHeadings;
use Maatwebsite\Excel\Concerns\WithDrawings;
use PhpOffice\PhpSpreadsheet\Worksheet\Drawing;

class BandSaleExport implements FromCollection, WithHeadings, WithDrawings
{
    protected $data;
    protected $imageCoordinates = [];

    public function __construct($data)
    {
        $this->data = $data;
    }

    public function headings(): array
    {
        return [
            'SL',
            'Invoice',
            'Customer',
            'Billing Date',
            'Service',
            'Qty',
            'Rate',
            'VAT',
            'From',
            'To',
            'Line Total',
            'Total',
            'Discount',
            'Paid',
            'Due',
        ];
    }

    public function collection()
    {
        $rows = [];
        $sl = 1;
        $grandTotal = 0;
        $grandDiscount = 0;
        $grandPaid = 0;
        $grandDue = 0;
        $rowIndex = 2;

        foreach ($this->data as $sale) {
            $total = $sale->total;
            $discount = $sale->discount;
            $paid = $sale->paid;
            $due = $total - ($paid + $discount);

            $grandTotal += $total;
            $grandDiscount += $discount;
            $grandPaid += $paid;
            $grandDue += $due;

            $rows[] = [
                $sl++,
                $sale->invoice_no,
                $sale->bandwidthSaleCustomer->customer_name ?? '',
                Carbon::parse($sale->billing_date)->format('d-M-Y'),
                '',
                '',
                '',
                '',
                '',
                '',
                '',
                number_format($total, 2),
                number_format($discount, 2),
                number_format($paid, 2),
                number_format($due, 2)
            ];
            $rowIndex++; // Increment row index after each row

            // Service Rows
            foreach ($sale->sateItems as $item) {
                $rows[] = [
                    '',
                    '',
                    '',
                    '',
                    $item->service->name ?? '',
                    $item->quantity ?? '',
                    $item->rate ?? '',
                    $item->vat ?? '',
                    Carbon::parse($item->from_date)->format('d-M-Y'),
                    Carbon::parse($item->to_date)->format('d-M-Y'),
                    number_format($item->line_total, 2),
                    '',
                    '',
                    '',
                    '',
                ];
                $rowIndex++; // count service row
            }

            // Optional: blank row between invoices
            $rows[] = ['', '', '', '', '', '', '', '', '', '', '', '', '', ''];
            $rowIndex++; // count blank row
        }

        // Add Grand Total Row
        $rows[] = [
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            '',
            'Total',
            number_format($grandTotal, 2),
            number_format($grandDiscount, 2),
            number_format($grandPaid, 2),
            number_format($grandDue, 2)
        ];

        return collect($rows);
    }

    public function drawings()
    {
        $drawings = [];

        foreach ($this->imageCoordinates as $img) {
            $drawing = new Drawing();
            $drawing->setName('Document');
            $drawing->setDescription('Sale Document');
            $drawing->setPath($img['path']);
            $drawing->setHeight(20);
            $drawing->setCoordinates($img['cell']);
            $drawings[] = $drawing;
        }

        return $drawings;
    }
}
