<?php

namespace Database\Seeders;


use Illuminate\Database\Seeder;
use App\Models\User;
use App\Models\User_details;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Spatie\Permission\Models\Role;

use Spatie\Permission\Models\Permission;

class NewRolePermissionSeeder extends Seeder
{
    /**
     * Run the database seeds.
     *
     * @return void
     */
    public function run()
    {
        $data = [
            [
                'permission_name' => 'payment-history',
                'role_ids' => [1]
            ],

        ];

        foreach ($data as $value) {
            $permission = Permission::where('name', $value['permission_name'])->first();
            if($permission) {
                foreach ($value['role_ids'] as $role_id) {
                    $role_permissions = DB::table('role_has_permissions')->where('permission_id', $permission->id)->where('role_id', $role_id)->first();
                    if(!$role_permissions) {
                        DB::table('role_has_permissions')->insert([
                            'permission_id' => $permission->id,
                            'role_id' => $role_id,
                        ]);
                    }
                }
            }
        }
    }
}
