<?php

namespace App\Classes\Accounting;

use App\Models\AccountingServer;
use Illuminate\Support\Facades\DB;

class ActiveServers
{
    protected  $activeServers;
    public function __construct()
    {
        $this->activeServers =  cache()->remember('activeServerLists', 60 * 60, function () {
            return AccountingServer::where('is_enable', 1)->get();
        });
    }

    public function runQuery($callback)
    {
        foreach ($this->activeServers as $server) {
            $callback(DB::connection($server->name));
        }
    }
}
