<?php

namespace App\Jobs;

use App\Services\BatchExpChangeService;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldBeUnique;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class BatchExpChange implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    private $clients;
    private $exp_date;
    private $auth_user;
    public function __construct($clients, $exp_date, $auth_user)
    {
        $this->clients = $clients;
        $this->exp_date = $exp_date;
        $this->auth_user = $auth_user;
    }

    public function handle()
    {
        foreach ($this->clients as $user) {
            echo $user->id . '<br>';
            (new BatchExpChangeService)->batchExpChange($user, $this->exp_date, $this->auth_user);
        }
    }
}
