import { useReducer } from "react";
import { Button, Col, Form, Row } from "react-bootstrap";
import { TJBoxConnectUpStream } from "./TJBoxConnectUpStream";
import { TJBoxConnectDownStream } from "./TJBoxConnectDownStream";
import axiosInstance from "../../../../../util/axiosInstance";
import toast from "react-hot-toast";

const TjBoxConnectReducer = (state, action) => {
    switch (action.type) {
        case "SET_UP_STREAM":
            return {
                ...state,
                up_stream: action.up_stream_id,
                up_stream_tube: null,
                up_stream_fiber: null,
            };
        case "SET_UP_STREAM_TUBE":
            return {
                ...state,
                up_stream_tube: action.up_stream_tube_id,
            };
        case "SET_UP_STREAM_FIBER":
            return {
                ...state,
                up_stream_fiber: action.up_stream_fiber_id,
            };
        case "SET_DOWN_STREAM":
            return {
                ...state,
                down_stream: action.down_stream_id,
                down_stream_tube: null,
                down_stream_fiber: null,
            };
        case "SET_DOWN_STREAM_TUBE":
            return {
                ...state,
                down_stream_tube: action.down_stream_tube_id,
            };
        case "SET_DOWN_STREAM_FIBER":
            return {
                ...state,
                down_stream_fiber: action.down_stream_fiber_id,
            };
        default:
            return state;
    }
};

const initialState = {
    up_stream: null,
    up_stream_tube: null,
    up_stream_fiber: null,

    down_stream: null,
    down_stream_tube: null,
    down_stream_fiber: null,
};

export function TjConnect({ tjBoxInfo }) {
    const [tjBoxCableConnectInfo, tjBoxConnectDispatch] = useReducer(
        TjBoxConnectReducer,
        initialState
    );

    const onSubmitHandler = async (e) => {
        e.preventDefault();
        try {
            await axiosInstance.post("/cables/connect-fiber", {
                upStreamFiberId: tjBoxCableConnectInfo.up_stream_fiber,
                downStreamFiberId: tjBoxCableConnectInfo.down_stream_fiber,
            });
            toast.success("Successfully connected");
        } catch (error) {
            console.log(error);
        }
    };

    return (
        <Col lg={12}>
            <Form
                className="rounded shadow-sm m-2 p-2 border border-secondary border-1"
                onSubmit={onSubmitHandler}
            >
                <Row>
                    <TJBoxConnectUpStream
                        up_stream={tjBoxInfo.up_stream}
                        tjBoxCableConnectInfo={tjBoxCableConnectInfo}
                        tjBoxConnectDispatch={tjBoxConnectDispatch}
                    />
                    <TJBoxConnectDownStream
                        down_stream={tjBoxInfo.down_stream}
                        tjBoxCableConnectInfo={tjBoxCableConnectInfo}
                        tjBoxConnectDispatch={tjBoxConnectDispatch}
                    />
                </Row>
                <div className="d-flex justify-content-end">
                    <Button className="mt-3" type="submit">
                        Connect
                    </Button>
                </div>
            </Form>
        </Col>
    );
}
